"use strict";

describe("ContextModule.AppContextManager", function() {

    var serializedAppContexts = {
            "empty": {
                "stateHistory": {
                    "currentSerializedState": {
                        "musicCollectionGrid": {
                            "entityConfigs": [],
                            "viewConfigs": [],
                        },
                        "musicRecordingGrid": {
                            "entityConfigs": [],
                            "viewConfigs": [],
                        }
                    },
                    "undoStack": [],
                    "redoStack": []
                },
                "stateBookmarks": []
            },

            "empty_faulty1": {
            },
            "empty_faulty2": 42,
            "empty_faulty3": null,
            
            "empty_incomplete1": {
                "stateHistory": {
                    "currentSerializedState": {
                        "musicCollectionGrid": {
                            "entityConfigs": [],
                            "viewConfigs": [],
                        },
                    },
                    "redoStack": []
                },
                "stateBookmarks": []
            },
            "empty_incomplete2": {
                "stateHistory": {
                    "currentSerializedState": null,
                    "undoStack": [],
                    "redoStack": []
                },
                "stateBookmarks": []
            },
    };
    
    beforeAll(function() {
        jasmine.helpers.dumpStorage();
        jasmine.helpers.clearStorage();
    });

    beforeEach(function() {
        jasmine.helpers.clearStorage();
    });
    
    afterAll(function() {
        jasmine.helpers.restoreStorageFromDump();
    });

    it("is promptly created", function() {
        var testedAppContextManager = new App.ContextModule.AppContextManager();
        
        expect(testedAppContextManager instanceof Backbone.Marionette.Object).toBe(true);
    });

    it("restores context from default, saves it and reads it", function() {
        var testedAppContextManager = new App.ContextModule.AppContextManager();
        var testedAppContext = new App.ContextModule.AppContext();
        
        testedAppContextManager.restoreDefault(testedAppContext);
        
        var serializedAppContext = testedAppContext.serialize();
        expect(typeof serializedAppContext).toBe("object");
        expect(serializedAppContext.stateHistory.currentSerializedState.musicCollectionGrid.entityConfigs.length).toBe(2);
        expect(serializedAppContext.stateHistory.currentSerializedState.musicCollectionGrid.viewConfigs.length).toBe(2);
        expect(serializedAppContext.stateHistory.currentSerializedState.musicRecordingGrid.entityConfigs.length).toBe(0);
        expect(serializedAppContext.stateHistory.currentSerializedState.musicRecordingGrid.viewConfigs.length).toBe(0);

        testedAppContextManager.saveToStorage(testedAppContext);
        var serializedAppContext = App.DataModule.Storage.getObjCache(App.ContextModule, "context");
        expect(typeof serializedAppContext).toBe("object");
        expect(serializedAppContext.stateHistory.currentSerializedState.musicCollectionGrid.entityConfigs.length).toBe(2);
        expect(serializedAppContext.stateHistory.currentSerializedState.musicCollectionGrid.viewConfigs.length).toBe(2);
        expect(serializedAppContext.stateHistory.currentSerializedState.musicRecordingGrid.entityConfigs.length).toBe(0);
        expect(serializedAppContext.stateHistory.currentSerializedState.musicRecordingGrid.viewConfigs.length).toBe(0);

        serializedAppContext.stateHistory.currentSerializedState.musicCollectionGrid.entityConfigs.pop();
        serializedAppContext.stateHistory.currentSerializedState.musicRecordingGrid.viewConfigs.push({parameters: {x: 1}});
        
        App.DataModule.Storage.setObjCache(App.ContextModule, "context", serializedAppContext);
        testedAppContextManager.restoreFromStorage(testedAppContext);
        var serializedAppContext = testedAppContext.serialize();
        expect(typeof serializedAppContext).toBe("object");
        expect(serializedAppContext.stateHistory.currentSerializedState.musicCollectionGrid.entityConfigs.length).toBe(1);
        expect(serializedAppContext.stateHistory.currentSerializedState.musicCollectionGrid.viewConfigs.length).toBe(2);
        expect(serializedAppContext.stateHistory.currentSerializedState.musicRecordingGrid.entityConfigs.length).toBe(0);
        expect(serializedAppContext.stateHistory.currentSerializedState.musicRecordingGrid.viewConfigs.length).toBe(1);
    });
});
